//
//  ViewController.swift
//  ProgressView
//
//  Created by 9Brainz on 24/12/18.
//  Copyright © 2018 9Brainz. All rights reserved.
//

import UIKit

class ViewController: UIViewController
{

    @IBOutlet weak var vwProgress: UIProgressView!
    @IBOutlet weak var btnStart: UIButton!
    
    var progressBarTimer: Timer!
    var isRunning = false
    
    override func viewDidLoad()
    {
        super.viewDidLoad()
        
        vwProgress.progress = 0.0
        
        vwProgress.transform = vwProgress.transform.scaledBy(x: 1, y: 5)
        vwProgress.layer.cornerRadius = 10
        vwProgress.clipsToBounds = true
        vwProgress.layer.sublayers![1].cornerRadius = 5
        vwProgress.subviews[1].clipsToBounds = true
        
        vwProgress.trackTintColor = UIColor.lightGray
        vwProgress.progressTintColor = UIColor.red

    }

    @IBAction func btnStart(_ sender: Any)
    {
        if(isRunning)
        {
            progressBarTimer.invalidate()
            btnStart.setTitle("Start", for: .normal)
        }
        else
        {
            btnStart.setTitle("Stop", for: .normal)
            vwProgress.progress = 0.0
            self.progressBarTimer = Timer.scheduledTimer(timeInterval: 0.5, target: self, selector: #selector(ViewController.updateProgressView), userInfo: nil, repeats: true)
        }
        isRunning = !isRunning
    }
    
    @objc func updateProgressView()
    {
        vwProgress.progress += 0.1
        vwProgress.setProgress(vwProgress.progress, animated: true)
        if(vwProgress.progress == 1.0)
        {
            progressBarTimer.invalidate()
            isRunning = false
            btnStart.setTitle("Start", for: .normal)
        }
    }
    
    override func didReceiveMemoryWarning()
    {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }
}

